package com.check.settlement.cronstart;

import com.check.settlement.service.CheckService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Configuration      //1.主要用于标记配置类，兼备Component的效果。
@EnableScheduling   // 2.开启定时任务
public class CronStart {
    @Autowired
    private CheckService checkService;

    @Scheduled(cron="0/30 * * * * ? ")
    public void start() {
        checkService.check();
    }
}
