package com.check.settlement.service.impl;

import com.check.settlement.mapper.CEPBalanceMapper;
import com.check.settlement.mapper.CEPDailyECBillMapper;
import com.check.settlement.mapper.TempAidenMapper;
import com.check.settlement.mapper.TradeDataMapper;
import com.check.settlement.model.CEPBalance;
import com.check.settlement.model.CEPDailyECBill;
import com.check.settlement.model.TempAiden;
import com.check.settlement.service.CheckService;
import com.check.settlement.service.TaoBaoTradeService;
import com.check.settlement.util.DateUtil;
import com.github.pagehelper.util.StringUtil;
import com.taobao.api.domain.Order;
import com.taobao.api.domain.Refund;
import com.taobao.api.domain.Trade;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@Service
public class CheckServiceImpl implements CheckService {
    @Autowired
    private TempAidenMapper tempAidenMapper;
    @Autowired
    private TaoBaoTradeService taoBaoTradeService;
    @Autowired
    private CEPDailyECBillMapper cepDailyECBillMapper;
    @Autowired
    private TradeDataMapper tradeDataMapper;
    @Autowired
    private CEPBalanceMapper cepBalanceMapper;

    @Override
    public void check() {
        for (int i = 0; i < 100; i++) {
            List<TempAiden> tempAidenList = tempAidenMapper.getTempAiden();
            if (CollectionUtils.isNotEmpty(tempAidenList)) {
                for (TempAiden tempAiden : tempAidenList) {
                    BigDecimal divideAmount = new BigDecimal(tempAiden.getContent());
                    BigDecimal actualAmount = new BigDecimal(tempAiden.getPayment());
                    BigDecimal cha = divideAmount.subtract(actualAmount);
                    List<Trade> tradeList = taoBaoTradeService.getTradeBytid(tempAiden.getTid());
                    if (CollectionUtils.isNotEmpty(tradeList)) {
                        for (Trade trade : tradeList) {
                            String sellerMemo = trade.getSellerMemo();
                            if (StringUtil.isNotEmpty(sellerMemo)) {
                                if ((sellerMemo.contains("会员") || sellerMemo.contains("白金"))) {
                                    member(trade, tempAiden, cha, actualAmount);
                                } else if (sellerMemo.contains("差价")) {
                                    spread(trade, tempAiden, cha);
                                } else if (sellerMemo.contains("换货")) {
                                    exchange(tempAiden, trade, actualAmount, cha);
                                } else if (sellerMemo.contains("礼盒")) {
                                    giftBox(trade, tempAiden, cha);
                                } else if (sellerMemo.contains("漏发")) {
                                    omission(tempAiden);
                                } else if (sellerMemo.contains("退货退款") || sellerMemo.contains("拦截") || sellerMemo.contains("磨损")) {
                                    refunds(trade, tempAiden, divideAmount, cha, actualAmount);
                                } else {
                                    tempAiden.setMsg("未知问题5");
                                    tempAiden.setSku("1");
                                    tempAidenMapper.updateTempAiden(tempAiden);
                                }
                            } else {
                                if (StringUtil.isNotEmpty(trade.getPostFee())) {
                                    postFee(cha, tempAiden, trade.getPostFee());
                                } else {
                                    tempAiden.setMsg("未知问题1");
                                    tempAiden.setSku("1");
                                    tempAidenMapper.updateTempAiden(tempAiden);
                                }

                            }
                        }
                    } else {
                        tempAiden.setMsg("未查询到订单");
                        tempAiden.setSku("1");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    }
                }
            } else {
                break;
            }
        }
    }

    /**
     * 会员问题
     *
     * @param trade
     * @param tempAiden
     */
    public void member(Trade trade, TempAiden tempAiden, BigDecimal cha, BigDecimal actualAmount) {
        List<Order> orderList = trade.getOrders();
        if (CollectionUtils.isNotEmpty(orderList)) {
            List<Refund> refunds = new ArrayList<>();
            for (Order order : orderList) {
                List<Refund> refundList = taoBaoTradeService.getRefundByRefundId(order.getRefundId());
                if (CollectionUtils.isNotEmpty(refundList)) {
                    refunds.addAll(refundList);
                }
            }
            if (CollectionUtils.isNotEmpty(refunds)) {
                if (refunds.size() == 1) {
                    Refund refund = refunds.get(0);
                    BigDecimal refundFee = new BigDecimal(refund.getRefundFee());
                    if ((cha.compareTo(refundFee) == 0) || (actualAmount.doubleValue() < 0 && actualAmount.abs().compareTo(refundFee) == 0)) {
                        tempAiden.setMsg("白金会员补差价");
                        tempAiden.setSku("2");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    } else {
                        if (StringUtil.isNotEmpty(trade.getPostFee())) {
                            BigDecimal postFee = new BigDecimal(trade.getPostFee());
                            BigDecimal cha2 = refundFee.subtract(postFee);
                            if (cha.compareTo(cha2) == 0) {
                                tempAiden.setMsg("白金会员补差价+邮费");
                                tempAiden.setSku("2");
                                tempAidenMapper.updateTempAiden(tempAiden);
                            } else {
                                tempAiden.setMsg("未知问题3");
                                tempAiden.setSku("1");
                                tempAidenMapper.updateTempAiden(tempAiden);
                            }
                        } else {
                            tempAiden.setMsg("未知问题2");
                            tempAiden.setSku("1");
                            tempAidenMapper.updateTempAiden(tempAiden);
                        }
                    }
                } else {
                    tempAiden.setMsg("会员查询到多个退单");
                    tempAiden.setSku("1");
                    tempAidenMapper.updateTempAiden(tempAiden);
                }
            } else {
                tempAiden.setMsg("会员未查询到退单");
                tempAiden.setSku("1");
                tempAidenMapper.updateTempAiden(tempAiden);
            }
        }
    }

    /**
     * 邮费问题
     *
     * @param cha
     * @param tempAiden
     * @param postFee
     */
    public void postFee(BigDecimal cha, TempAiden tempAiden, String postFee) {
        double chaDouble = cha.doubleValue();
        BigDecimal post = new BigDecimal(postFee);
        if (chaDouble < 0 && cha.abs().compareTo(post.abs()) == 0) {
            tempAiden.setMsg("邮费");
            tempAiden.setSku("2");
            tempAidenMapper.updateTempAiden(tempAiden);
        } else {
            tempAiden.setMsg("未知问题4");
            tempAiden.setSku("1");
            tempAidenMapper.updateTempAiden(tempAiden);
        }
    }

    /**
     * 差价
     */
    public void spread(Trade trade, TempAiden tempAiden, BigDecimal cha) {
        List<Order> orderList = trade.getOrders();
        if (CollectionUtils.isNotEmpty(orderList)) {
            List<Refund> refunds = new ArrayList<>();
            for (Order order : orderList) {
                List<Refund> refundList = taoBaoTradeService.getRefundByRefundId(order.getRefundId());
                if (CollectionUtils.isNotEmpty(refundList)) {
                    refunds.addAll(refundList);
                }
            }
            if (CollectionUtils.isNotEmpty(refunds)) {
                if (refunds.size() == 1) {
                    Refund refund = refunds.get(0);
                    BigDecimal refundFee = new BigDecimal(refund.getRefundFee());
                    if (cha.compareTo(refundFee) == 0) {
                        tempAiden.setMsg("补差");
                        tempAiden.setSku("2");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    } else {
                        tempAiden.setMsg("未知问题6");
                        tempAiden.setSku("1");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    }
                } else {
                    tempAiden.setMsg("差价查询到多个退单");
                    tempAiden.setSku("1");
                    tempAidenMapper.updateTempAiden(tempAiden);
                }
            } else {
                tempAiden.setMsg("差价未查询到退单");
                tempAiden.setSku("1");
                tempAidenMapper.updateTempAiden(tempAiden);
            }
        }
    }

    /**
     * 换货
     */
    public void exchange(TempAiden tempAiden, Trade trade, BigDecimal actualAmount, BigDecimal cha) {
        String tradeGuid = tradeDataMapper.getTradeGuidBytid(tempAiden.getTid());
        String orderReturnFeedback = tradeDataMapper.getOrderReturnFeedbackByGuid(tradeGuid);
        List<String> returnGuidList = tradeDataMapper.getCEPReturnBytid(tempAiden.getTid());
        List<String> csReturnGuid = tradeDataMapper.getCSReturnBytid(tempAiden.getTid());
        List<String> splitList = tradeDataMapper.getSplitTradeBytid(tempAiden.getTid());
        if (actualAmount.abs().compareTo(cha.abs()) == 0 && StringUtil.isNotEmpty(orderReturnFeedback) && CollectionUtils.isNotEmpty(splitList) && CollectionUtils.isEmpty(returnGuidList) && CollectionUtils.isEmpty(csReturnGuid)) {
            tempAiden.setMsg("换货，返品待确认");
            tempAiden.setSku("2");
            tempAidenMapper.updateTempAiden(tempAiden);
        } else {
            List<Order> orderList = trade.getOrders();
            boolean flag = true;
            if (CollectionUtils.isNotEmpty(orderList)) {
                for (Order order : orderList) {
                    BigDecimal payment = new BigDecimal(order.getPayment());
                    BigDecimal partMjzDiscount = new BigDecimal(StringUtil.isNotEmpty(order.getPartMjzDiscount()) ? order.getPartMjzDiscount() : "0");
                    BigDecimal price = payment.subtract(partMjzDiscount);
                    List<CEPBalance> cepBalanceList = cepBalanceMapper.getBalanceByTid(tempAiden.getTid(), order.getOuterSkuId());
                    if (CollectionUtils.isNotEmpty(cepBalanceList)) {
                        for (CEPBalance cepBalance : cepBalanceList) {
                            BigDecimal amount = new BigDecimal(cepBalance.getAmount());
                            if (price.abs().compareTo(amount.abs()) == -1 && amount.doubleValue() < 0) {
                                tempAiden.setMsg("换货，负向金额处理不对");
                                tempAiden.setSku("2");
                                tempAidenMapper.updateTempAiden(tempAiden);
                                flag = false;
                                break;
                            }
                        }
                    }
                }
            }
            if (flag) {
                tempAiden.setMsg("换货未知问题");
                tempAiden.setSku("1");
                tempAidenMapper.updateTempAiden(tempAiden);
            }
        }
    }

    /**
     * 礼盒
     *
     * @param trade
     * @param tempAiden
     * @param cha
     */
    public void giftBox(Trade trade, TempAiden tempAiden, BigDecimal cha) {
        List<Order> orderList = trade.getOrders();
        if (CollectionUtils.isNotEmpty(orderList)) {
            List<Refund> refunds = new ArrayList<>();
            for (Order order : orderList) {
                List<Refund> refundList = taoBaoTradeService.getRefundByRefundId(order.getRefundId());
                if (CollectionUtils.isNotEmpty(refundList)) {
                    refunds.addAll(refundList);
                }
            }
            if (CollectionUtils.isNotEmpty(refunds)) {
                if (refunds.size() == 1) {
                    Refund refund = refunds.get(0);
                    BigDecimal refundFee = new BigDecimal(refund.getRefundFee());
                    if (cha.compareTo(refundFee) == 0) {
                        tempAiden.setMsg("礼盒退还");
                        tempAiden.setSku("2");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    } else {
                        tempAiden.setMsg("未知问题8");
                        tempAiden.setSku("1");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    }
                } else {
                    tempAiden.setMsg("礼盒查询到多个退单");
                    tempAiden.setSku("1");
                    tempAidenMapper.updateTempAiden(tempAiden);
                }
            } else {
                tempAiden.setMsg("礼盒未查询到退单");
                tempAiden.setSku("1");
                tempAidenMapper.updateTempAiden(tempAiden);
            }
        }
    }

    /**
     * 漏发
     *
     * @param tempAiden
     */
    public void omission(TempAiden tempAiden) {
        tempAiden.setMsg("漏发，补发");
        tempAiden.setSku("2");
        tempAidenMapper.updateTempAiden(tempAiden);
    }

    /**
     * 退货退款
     *
     * @param trade
     * @param tempAiden
     * @param divideAmount
     */
    public void refunds(Trade trade, TempAiden tempAiden, BigDecimal divideAmount, BigDecimal cha, BigDecimal actualAmount) {
        List<Order> orderList = trade.getOrders();
        if (CollectionUtils.isNotEmpty(orderList)) {
            List<Refund> refunds = new ArrayList<>();
            for (Order order : orderList) {
                List<Refund> refundList = taoBaoTradeService.getRefundByRefundId(order.getRefundId());
                if (CollectionUtils.isNotEmpty(refundList)) {
                    refunds.addAll(refundList);
                }
            }
            if (CollectionUtils.isNotEmpty(refunds)) {
                if (refunds.size() == 1) {
                    Refund refund = refunds.get(0);
                    BigDecimal refundFee = new BigDecimal(refund.getRefundFee());
                    if (divideAmount.doubleValue() == 0 && cha.abs().compareTo(refundFee.abs()) == 0 && actualAmount.doubleValue() < 0) {
                        tempAiden.setMsg("四月结算，五月负销售");
                        tempAiden.setSku("2");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    } else if (divideAmount.doubleValue() == 0 && cha.abs().compareTo(refundFee.abs()) == 0 && actualAmount.doubleValue() > 0) {
                        tempAiden.setMsg("五月结算，负销售应该在6月");
                        tempAiden.setSku("2");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    } else {
                        tempAiden.setMsg("未知问题8");
                        tempAiden.setSku("1");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    }
                } else {
                    BigDecimal refundAmunt = new BigDecimal("0");
                    for (Refund refund : refunds) {
                        BigDecimal refundFee = new BigDecimal(refund.getRefundFee());
                        refundAmunt = refundAmunt.add(refundFee);
                    }
                    if (actualAmount.abs().compareTo(refundAmunt) == 0) {
                        List<CEPDailyECBill> cepDailyECBillList = cepDailyECBillMapper.getDailyecbillByTid(tempAiden.getTid());
                        if (CollectionUtils.isNotEmpty(cepDailyECBillList)) {
                            boolean flag4 = false;
                            boolean flag5 = false;
                            for(CEPDailyECBill cepDailyECBill : cepDailyECBillList){
                                String date = DateUtil.getMonth(cepDailyECBill.getUpdateddate());
                                if ("2021-04".equals(date)) {
                                    flag4 = true;
                                    break;
                                }
                                if("2021-05".equals(date)) {
                                    flag4 = true;
                                    break;
                                }
                            }
                            if(flag4 && flag5){
                                tempAiden.setMsg("四月结算，五月负销售");
                                tempAiden.setSku("2");
                                tempAidenMapper.updateTempAiden(tempAiden);
                            } else {
                                tempAiden.setMsg("退货退款未知问题");
                                tempAiden.setSku("1");
                                tempAidenMapper.updateTempAiden(tempAiden);
                            }
                        } else {
                            tempAiden.setMsg("未查询到结算数据");
                            tempAiden.setSku("1");
                            tempAidenMapper.updateTempAiden(tempAiden);
                        }
                    } else {
                        tempAiden.setMsg("退货退款查询到多个退单");
                        tempAiden.setSku("1");
                        tempAidenMapper.updateTempAiden(tempAiden);
                    }
                }
            } else {
                tempAiden.setMsg("退货退款未查询到退单");
                tempAiden.setSku("1");
                tempAidenMapper.updateTempAiden(tempAiden);
            }
        }
    }

}
