package com.check.settlement.service.impl;

import com.check.settlement.Response.TaoBaoTrade;
import com.check.settlement.mapper.TaoBaoItemMapper;
import com.check.settlement.service.TaoBaoTradeService;
import com.taobao.api.ApiException;
import com.taobao.api.domain.Refund;
import com.taobao.api.domain.Trade;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.response.RefundGetResponse;
import com.taobao.api.response.TradeFullinfoGetResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
@Service
public class TaoBaoTradeServiceImpl implements TaoBaoTradeService {
    @Autowired
    private TaoBaoItemMapper taoBaoItemMapper;
    @Override
    public List<Trade> getTradeBytid(String tid) {
        List<TaoBaoTrade> taoBaoTradeList = taoBaoItemMapper.getTradeByTid(tid);
        if(CollectionUtils.isNotEmpty(taoBaoTradeList)){
            List<Trade> tradeList=new ArrayList<Trade>();
            for (TaoBaoTrade trade:taoBaoTradeList){
                try {
                    TradeFullinfoGetResponse rsp = TaobaoUtils.parseResponse(
                            trade.getJdp_response(), TradeFullinfoGetResponse.class);
                    tradeList.add(rsp.getTrade());
                } catch (ApiException e) {
                    e.printStackTrace();
                }
            }
            return tradeList;
        }
        return null;
    }

    @Override
    public List<Refund> getRefundByRefundId(String refundId) {
        List<TaoBaoTrade> tradeList = taoBaoItemMapper.getRefundTradeByRefundId(refundId);
        if(CollectionUtils.isNotEmpty(tradeList)){
            List<Refund> returnList=new ArrayList<Refund>();
            for (TaoBaoTrade trade:tradeList){
                try {
                    RefundGetResponse rsp = TaobaoUtils.parseResponse(
                            trade.getJdp_response(), RefundGetResponse.class);
                    returnList.add(rsp.getRefund());
                } catch (ApiException e) {
                    e.printStackTrace();
                }
            }
            return returnList;
        }
        return null;
    }


}
