import Request from '../static/plugin/luch-request/index.js'
const http = new Request();

const install = (Vue, vm) => {
	http.setConfig(config => {
		config.baseURL = 'https://api.charleskeith.cn'  // 正式环境
		// config.baseURL = 'http://47.101.191.49:8083'   // 外网测试环境
		// config.baseURL =  'http://192.168.138.55:8081'   // 测试环境
		config.custom = {
			loading: false
		},
		// 配置请求头信息
		config.header = {
			"Content-Type": "application/json",
			"Type": "wx"
		}
		return config
	})
	
	/**
	 * 请求拦截
	 */
	http.interceptors.request.use((config) => {
		if (config.custom.loading) {
			uni.showLoading()
		}
		config.header.Authorization = vm.vuex_token
		return config
	}, (config) => {
		return Promise.reject(config)
	})
	
	/**
	 * 响应拦截
	 */
	http.interceptors.response.use((res) => {
		if (res.config.custom.loading) {
			uni.hideLoading()
		}
		if (res.statusCode > 300 || res.statusCode < 200) { 
			return Promise.reject(res)  
		}
		return res
	}, (error) => {
		if (error.config.custom.loading) {
			uni.hideLoading()
		}
		const { statusCode, data } = error
		if(statusCode == 400) {
			vm.$u.toast(data.message)
			return false
		} else if(statusCode == 401) {
			if(data.massage === 'Unauthorized') {
				vm.$u.toast("账号或密码错误")
			} else if(data.message === "Token has expired") {
				vm.$u.toast("Token 已过期, 请重新登录")
			}
			return false
		}  else {
			vm.$u.toast("请求失败，到控制台查看原因")
			return false
		}
		return Promise.resolve(error)
	})
	
	vm.$http = http
}

export default {
	install
}