
const install = (Vue, vm) => {	
	/* 通用转换报表数据格式
	  @data: 传入的数据
	  @element: 图表的配置
	*/
	const parseChartData = (data, element) => {
	  const list = handleChartsList(handleChartData(data, element.data.dataConfig.data))
	  return convertChartsData(list, element)
	}
	/* 通用转换报表数据格式
	  @list: 数据列表
	  @dimension: 维度
	  @value: 数据
	  @condition:对应的条件配置
	  @type: 报表类型
	*/
	// dimension, value, conditions, type: string
	 const convertChartsData = (list, element) => {
	  if (!element.data.dataConfig.value.length) {
	    return
	  }
	  if (!list) {
	    return
	  }
	  const type = element.type
	  if (type === 'NormalBar' || type === 'HorizontalBar') {
	    return convertBarData(list, element)
	  }
	  if (type === 'NormalLine') {
	    return convertLineData(list, element)
	  }
	  if (type === 'LineMixBar') {
	    return convertLineMixBarData(list, element)
	  }
	  
	  if (type === 'NormalPie') {
	    return convertPieData(list, element)
	  }
	  if (type === 'NormalRadar') {
	    return convertRadarData(list, element)
	  }
	  if (type === 'NormalGauge') {
	    return convertGuageData(list, element)
	  }
	  if (type === 'NormalTabs') {
	    return convertTabData(list, element)
	  }
	  if (type === 'NormalTable') {
	    return convertTableData(list, element)
	  }
	  if (type === 'NormalProgress') {
	    return convertProgressData(list, element)
	  }
	  if (type === 'CountTo' || type === 'CountTo' ) {
	    return convertNumberData(list, element)
	  }
	  if (type === 'BasicText') {
	    return convertTextData(list, element)
	  }
	  if (type === 'BarMixMap') {
	    return convertBarMixMapData(list, element)
	  }
	  if (type === 'ChinaMap') {
	    return convertChinaMapData(list, element)
	  }
	}
	/* 根据层级结构获取对应的数据
	  @obj: 传入的数据
	  @key: 对应的字段
	*/
	const filterChartData = (obj, key) => {
	  if (!key) {
	    return obj
	  }
	  for (const prop in obj) {
	    // eslint-disable-next-line no-prototype-builtins
	    if (obj.hasOwnProperty(prop)) {
	      if (prop === key) {
	        return obj[prop]
	      }
	      else if (obj.constructor === Object) {
	        const result = filterChartData(obj[prop], key)
	        if (result !== undefined) {
	          return result
	        }
	      }
	      else if (obj.constructor === Array) {
	        const result = filterChartData(obj[0], key)
	        if (result !== undefined) {
	          return result
	        }
	      }
	    }
	  }
	}
	/* item的数据格式：["string", "string"]
	  找到最外层的数据
	*/
	const handleChartData = (obj, item) => {
	  let result = obj
	  if (!item || !item.length) {
	    return result
	  }
	  item.forEach((child) => {
	    result = filterChartData(result, child)
	  })
	  return result
	}
	
	
	/* 处理图表类的数据
	  图表的数据，处理成数组格式
	*/
	const handleChartsList = (list) => {
	  if (list.constructor === String) {
	    return []
	  }
	  if (list.constructor === Object) {
	    const arr = []
	    arr.push(list)
	    return arr
	  }
	  return list
	}
	
	
	/* 解析条件判断
	  @condition:对应的条件配置
	  @data: 需要解析的数据
	*/ 
	const judgeConditions = (condition, data) => {
	  let number = 0
	  if (condition.length) {
	    condition.forEach((item) => {
	      let value = ''
	      value = handleChartData(data, item.field)
	      if (!value.length) {
	        number++
	      }
	      else {
	        const op = item.op
	        const val = item.value
	        if (op === 'GTR' && value > val) {
	          number++
	        }
	        if (op === 'GEQ' && value >= val) {
	          number++
	        }
	        if (op === 'EQU' && value === val) {
	          number++
	        }
	        if (op === 'LSS' && value < val) {
	          number++
	        }
	        if (op === 'LEQ' && value <= val) {
	          number++
	        }
	        if (op === 'NEQ' && value !== val) {
	          number++
	        }
	        if (op === 'CONT' && value.toString().includes(val)) {
	          number++
	        }
	      }
	    })
	  }
	
	  return condition.length === number
	}
	// 柱状图
	const convertBarData = (list, element) => {
	  return convertBarOrLineData(list, element)
	}
	
	// 折线图
	const convertLineData = (list, element) => {
	  return convertBarOrLineData(list, element)
	}
	
	// 柱状图或者折线图
	const convertBarOrLineData = (list, element) => {
	  const categories = []
	  const series  = []
	  const xAxis = element.data.dataConfig.dimension
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  if (!xAxis.length) {
	    return
	  }
	  list.forEach((item) => {
	    // 数据判断，符合条件的数据
	    if (judgeConditions(conditions, item)) {
	    // 对应的维度加入categories
	      categories.push(handleChartData(item, xAxis))
	
	      // 对应的值加入series
	      yAxis.forEach((y, idx) => {
	        let obj = {name: '', data: []}
	        if (series.length > idx) {
	          obj = series[idx]
	        }
	        else {
	          series.push(obj)
	        }
	        obj.name = y[y.length - 1]
	        obj.data.push(handleChartData(item, y))  
	      })
	    }
	  })
	  return {
	    categories: categories,
	    series: series
	  }
	}
	
	// 饼图
	const convertPieData = (list, element) => {
	  const xAxis = element.data.dataConfig.dimension
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  if (!xAxis.length) {
	    return
	  }
	  const series = []
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      const obj = {
	        name: handleChartData(item, xAxis),
	        value: handleChartData(item, yAxis)
	      }
	      series.push(obj)
	    }
	  })
	  return { series }
	}
	
	
	// 折柱图
	const convertLineMixBarData = (list, element) => {
	  const categories = []
	  const series  = []
	  const xAxis = element.data.dataConfig.dimension
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  if (!xAxis.length) {
	    return
	  }
	  const length = yAxis.length / 2
	  list.forEach((item) => {
	    // 数据判断，符合条件的数据
	    if (judgeConditions(conditions, item)) {
	    // 对应的维度加入categories
	      // categories.push(item[key])
	      categories.push(handleChartData(item, xAxis))
	      // 对应的值加入series
	      yAxis.forEach((y, idx) => {
	        let obj = {name: '', data: [], type: ''}
	        if (series.length > idx) {
	          obj = series[idx]
	        }
	        else {
	          series.push(obj)
	        }
	        if (idx < length) {
	          obj.type = 'bar'
	        }
	        else {
	          obj.type = 'line'
	        }
	        obj.name = y[y.length - 1]
	        obj.data.push(handleChartData(item, y))  
	      })
	    }
	  })
	  return {
	    categories: categories,
	    series: series
	  }
	}
	
	// 雷达图
	const convertRadarData = (list, element) => {
	  const series = []
	  const indicator = []
	  const xAxis = element.data.dataConfig.dimension
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  if (!xAxis.length) {
	    return
	  }
	  list.forEach((item) => {
	    // 数据判断，符合条件的数据
	    if (judgeConditions(conditions, item)) {
	    // 对应的维度加入categories
	      indicator.push({
	        name: handleChartData(item, xAxis)
	      })
	      // 对应的值加入series
	      yAxis.forEach((y, idx) => {
	        let obj = {name: '', data: []}
	        if (series.length > idx) {
	          obj = series[idx]
	        }
	        else {
	          series.push(obj)
	        }
	        obj.name = y[y.length - 1]
	        obj.data.push(handleChartData(item, y))  
	      })
	    }
	  })
	  return {
	    indicator: indicator,
	    series: series
	  }
	}
	
	// 选项卡
	const convertTabData = (list, element) => {
	  const xAxis = element.data.dataConfig.dimension
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  if (!xAxis.length) {
	    return
	  }
	  const series = []
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      xAxis.forEach((x, idx) => {
	        const name = handleChartData(item, x)
	        let value = ''
	        if (yAxis.length >= xAxis.length ) {
	          value = handleChartData(item, yAxis[idx])
	        }
	        const obj = {
	          name: name,
	          value: value
	        }
	        series.push(obj)
	      })
	    }
	  })
	  return { series }
	}
	
	// 迁徙地图
	const convertChinaMapData = (list, element) => {
	  const coordinate = element.data.dataConfig.coordinate
	  const xAxis = element.data.dataConfig.dimension
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  if (!xAxis.length) {
	    return
	  }
	  const chinaMapAreas = []
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      const arr = []
	      const name = handleChartData(item, coordinate)
	      const obj = {
	        name: handleChartData(item, xAxis),
	        value: handleChartData(item, yAxis)
	      }
	      arr.push({ name })
	      arr.push(obj)
	      chinaMapAreas.push(arr)
	    }
	  })
	
	  return { chinaMapAreas }
	}
	
	// 地图混合柱状图
	const convertBarMixMapData = (list, element) => {
	  const xAxis = element.data.dataConfig.dimension
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  if (!xAxis.length) {
	    return
	  }
	  const series = []
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      const obj = {
	        name: handleChartData(item, xAxis),
	        value: handleChartData(item, yAxis)
	      }
	      series.push(obj)
	    }
	  })
	
	  return { series }
	}
	
	// 仪表盘
	const convertGuageData = (list, element) => {
	  const xAxis = element.data.dataConfig.dimension
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  if (!xAxis.length) {
	    return
	  }
	  const guageChart = []
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      xAxis.forEach((x, idx) => {
	        const name = handleChartData(item, x)
	        let value = ''
	        if (yAxis.length >= xAxis.length ) {
	          value = handleChartData(item, yAxis[idx])
	        }
	        const obj = {
	          name: name,
	          value: value
	        }
	        guageChart.push(obj)
	      })
	    }
	  })
	  return { guageChart }
	}
	
	// 表格
	const convertTableData = (list, element) => {
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  const chartTables = []
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      const obj = {}
	      yAxis.forEach((y, idx) => {
	        const key = y[y.length - 1]
	        const value = handleChartData(item, y)
	        obj[key] = value
	      })
	      chartTables.push(obj)
	    }
	  })
	
	  return { chartTables }
	}
	
	// 进度条
	const convertProgressData = (list, element) => {
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  let endVal = 0.0
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      endVal = parseFloat(handleChartData(item, yAxis)).toFixed(2)
	    }
	  })
	  return { endVal }
	}
	
	// 数字
	const convertNumberData = (list, element) => {
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  let endVal = 0
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      endVal = parseInt(handleChartData(item, yAxis))
	    }
	  })
	  return { endVal }
	}
	
	// 文本
	const convertTextData = (list, element) => {
	  const yAxis = element.data.dataConfig.value
	  const conditions = element.data.dataConfig.conditions
	  let text = ''
	  list.forEach((item) => {
	    if (judgeConditions(conditions, item)) {
	      text = handleChartData(item, yAxis)
	    }
	  })
	  return { text }
	}


	vm.$u.charts = {
		parseChartData,
	}
}

export default {
	install
}