export default {
  data() {
    return {
      elementData: {
        dataList: {}
      },
      timer: null
    }
  },
  props: {
    elementInfo: {
      type: Object,
      required: true
    },
    styleType: {
      type: String,
      default: ''
    }
  },
  methods: {
		setStorageData() {
			uni.setStorageSync(this.elementInfo.id, JSON.stringify(this.elementData.dataList))
		},
		/**
		 * 静态数据
		 */
		handleStaticData(value) {
			this.elementData.dataList = JSON.parse(JSON.stringify({...value.dataList}))
		},
		/**
		 * 动态数据
		 */
		async handleDynamicData (value) {
			const that = this
			let { dataUrl, dataMethod, dataFormatter, dataProcessing, dataConfig } = { ...value }
			if (!dataUrl.length) {
	      return
			}

			if(value.queryFormatter) dataFormatter = {...dataFormatter, ...value.queryFormatter}
			dataUrl = dataUrl.replace(/^(\/(dashboardCharts|dashboardAPI))?/, '')
			dataFormatter = that.$u.common.filterRequestParams({...dataFormatter})
			let res = await that.$u.api[`${dataMethod.toLowerCase()}Http`](dataUrl, dataFormatter, {
				custom: { loading: false }
			})
			if (that.elementInfo.type === 'folder') {
				that.setFolderData(res.data)
			}
			if (dataProcessing) {
				that.elementData.dataList = that.$u.common.converFunction(dataProcessing, res.data, value.queryFormatter)
			} else if (dataConfig && dataConfig.value && dataConfig.value.length) {
				that.elementData.dataList = that.$u.charts.parseChartData(res.data, that.elementInfo)
			} else {
				that.elementData.dataList = JSON.parse(JSON.stringify(res.data))
			}
		},
		
		setFolderData (value) {
			let data = {}
			if(this.vuex_folderData) {
				data = {...this.vuex_folderData}
			}
			data[this.elementInfo.id] = value
			this.$u.vuex('vuex_folderData', data)
		},
		
		/**
		 * 全局数据
		 */
		handlePublicData (value) {
			if (!this.vuex_globalData) return
			const { dataProcessing, dataConfig} = { ...value }
			if (dataProcessing) {
				this.elementData.dataList = this.$u.common.converFunction(dataProcessing, this.vuex_globalData, value.queryFormatter)
			} else if (dataConfig && dataConfig.value && dataConfig.value.length) {
				this.elementData.dataList = this.$u.charts.parseChartData(this.vuex_globalData, this.elementInfo)
			} else {
				this.elementData.dataList = this.vuex_globalData
			}
		},
		/**
		 * 配置数据 - 数据集
		 */
		async handleDataSet (value) {
			const { dataSetInfo } = value
			const that = this
			let res = await that.$u.api.dataSetPreview(dataSetInfo)
			const { Status, Msg } = res.data;
			if (Status == "true") {
				if(dataSetInfo.script) {
					that.elementData.dataList = that.$u.common.converFunction(dataSetInfo.script, res.data.Result)
				} else {
					that.elementData.dataList = res.data.Result
				}
			} else {
				that.$u.toast(Msg)
			}
		},
		
		/**
			* 视图配置
		*/
		async handleViewConfig (value) {
			const { viewConfig } = value
			if (!viewConfig.dataSetId) return
			const that = this
			const res = await that.$u.api.buildChart(viewConfig)
			const { Status, Msg, Result } = res.data
			if (Status === 'true') {
				that.elementData.dataList = Result
			}else {
				message.warning(Msg)
			}
		},

		/** 文件数据 */
		handleFolderData(value) {
			const that = this
			const { dataProcessing, dataConfig} = { ...value }
			if (that.vuex_folderData) {
				// 缓存好数据，切换tab时候用
				const json = that.vuex_folderData[that.elementInfo.folderId]
				if (dataProcessing) {
					that.elementData.dataList = that.$u.common.converFunction(dataProcessing, json, value.queryFormatter)
				} else if (dataConfig && dataConfig.value && dataConfig.value.length) {
					that.elementData.dataList = that.$u.charts.parseChartData(json, that.elementInfo)
				} else {
					that.elementData.dataList = json
				}
			}
			// 首次加载用
			uni.$on(`folder_${that.elementInfo.folderId}`, data => {
				if (!data) return
				if (dataProcessing) {
					that.elementData.dataList = that.$u.common.converFunction(dataProcessing, data)
					return
				}
				if (dataConfig && dataConfig.value && dataConfig.value.length) {
					that.elementData.dataList = that.$u.charts.parseChartData(data, that.elementInfo)
					return
				}
				that.elementData.dataList = JSON.parse(JSON.stringify(data))
			})
		},
		
		clearTimer() {
			clearInterval(this.timer)
			this.timer = null
		},
		/**
		 * 组件点击交互 - 传参
		 */
		handleEchartsClick (chartEvent ) {
			const { index, paramName } = this.elementInfo.child
			uni.$emit('handleLinkParams', { index, paramName, value: chartEvent.name })
		},
		/**
		 * 组件datazoom交互 
		 */
		echartsDataZoom (chartEvent ) {
			const { index, paramName } = this.elementInfo.child
			uni.$emit('handleDataZoomParams', { index, paramName, value: chartEvent })
		}
  },
  deactivated() {
    this.clearTimer()
  },
  beforeDestroy() {
    this.clearTimer()
  },
  watch: {
		'elementInfo.data': {
			handler(newVal) {
				const that = this
				const storageData = uni.getStorageSync(this.elementInfo.id)
				if(storageData && JSON.stringify(storageData) != "{}" && newVal.dataType !== 'static') {
					this.elementData.dataList = JSON.parse(storageData)
				}
				if(that.elementInfo.hide) return false
				if (newVal.dataType === 'static') {
					that.handleStaticData(newVal)
				} else if (newVal.dataType === 'dynamic') {
					that.handleDynamicData(newVal)
					if (newVal.dataPolling && newVal.dataPollingInterval > 0) {
						that.timer = setInterval(() => {
							that.handleDynamicData(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				} else if (newVal.dataType === 'public') {
					if(that.vuex_globalData && that.vuex_globalData.elements.includes(that.elementInfo.id)) {
						that.handlePublicData(newVal)
					}
				} else if (newVal.dataType === 'dataSet') {
					that.handleDataSet(newVal)
					if (newVal.dataPolling && newVal.dataPollingInterval > 0) {
						that.timer = setInterval(() => {
							that.handleDataSet(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				} else if (newVal.dataType === 'viewConfig') {
					that.handleViewConfig(newVal)
					if (newVal.dataPolling && newVal.dataPollingInterval > 0) {
						that.timer = setInterval(() => {
							that.handleViewConfig(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				} else if (newVal.dataType === 'folder') {
					that.handleFolderData(newVal)
					if (newVal.dataPolling && newVal.dataPollingInterval > 0) {
						that.timer = setInterval(() => {
							that.handleFolderData(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				}
			},
			deep: true,
			immediate: true
		},
		/**
		 * 全局数据更新监测
		 */
		'vuex_globalData' (newVal) {
			const elements = newVal.elements
			/* elements.includes(this.elementInfo.id) 全局数据对应的elements包含当前的element id，
			否则在切换页面的时候，被切换页面的全局组件也会再次请求,导致报错
			*/
			if (elements.includes(this.elementInfo.id) && this.elementInfo.data.dataType === 'public') {
				this.handlePublicData(this.elementInfo.data)				
			}
		},
		'elementData.dataList': {
			handler(newVal,oldVal) {
				if (JSON.stringify(newVal) !== '{}' && JSON.stringify(newVal) !== JSON.stringify(oldVal) ) {
					this.setStorageData()
					this.initChart()
				}
			},
			deep: true,
			immediate: true
		}
  }
}
