export default {
  data() {
    return {
      elementData: {},
      timer: null
    }
  },
  props: {
    elementInfo: {
			type: Object,
			required: true
		}
  },
  methods: {
		/**
		 * 静态数据
		 */
		handleStaticData(value) {
			this.elementData = JSON.parse(JSON.stringify({...value}))
			this.initChart()
		},
		/**
		 * 动态数据
		 */
		async handleDynamicData (value) {
			let { dataUrl, dataMethod, dataFormatter, dataProcessing } = { ...value }
			dataUrl = dataUrl.replace(/^(\/dashboardCharts)?|^(\/dashboardAPI)?/, '')
			if (value.queryFormatter) dataFormatter = {...dataFormatter, ...value.queryFormatter}
			let res = await this.$u[dataMethod.toLowerCase()](dataUrl, dataFormatter)
			if (dataProcessing) {
				this.elementData.dataList = this.$u.common.converFunction(dataProcessing, res.data)
			} else {
				this.elementData.dataList = JSON.parse(JSON.stringify(res.data.Result))
			}
			this.initChart()
		},
		/**
		 * 全局数据
		 */
		handlePublicData (value) {
			
		},
		/**
		 * 配置数据 - 数据集
		 */
		async handleDataSet (value) {
			const { dataSetInfo } = value
			let res = await this.$u.api.dataSetPreview(dataSetInfo)
			const { Status, Msg } = res.data;
			if (Status == "true") {
				if(dataSetInfo.script) {
					this.elementData.dataList = this.$u.common.converFunction(dataSetInfo.script, res.data.Result)
				} else {
					this.elementData.dataList = res.data.Result
				}
				this.initChart()
			} else {
				this.$u.toast(Msg)
			}
		},
    clearTimer() {
      clearInterval(this.timer)
      this.timer = null
    }
  },
  deactivated() {
    this.clearTimer()
  },
  beforeDestroy() {
    this.clearTimer()
  },
  watch: {
		'elementInfo.data': {
			handler(newVal) {
				if (newVal.dataType === 'static') {
					this.handleStaticData(newVal)
				}
				else if (newVal.dataType === 'dynamic') {
					this.handleDynamicData(newVal)
					if (newVal.dataPolling) {
						this.timer = setInterval(() => {
							this.handleDynamicData(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(this.timer)
					}
				}
				else if (newVal.dataType === 'public') {
					this.handlePublicData(newVal)
				}
				else if (newVal.dataType === 'dataSet') {
					this.handleDataSet(newVal)
					if (newVal.dataPolling) {
						this.timer = setInterval(() => {
							this.handleDataSet(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(this.timer)
					}
				}
			},
			immediate: true,
			deep: true
		}
  }
}
