import Vue from 'vue'
import App from './App'

Vue.config.productionTip = false

App.mpType = 'app'

// 引入全局uView
import uView from 'uview-ui'
Vue.use(uView);

let vuexStore = require('@/store/$u.mixin.js')
Vue.mixin(vuexStore)

import store from '@/store/index.js'

import * as echarts from '@/uni-ec-canvas/echarts'
import * as chinaJson from '@/uni-ec-canvas/china.json'
echarts.registerMap('china', chinaJson)
Vue.prototype.$echarts = echarts

const app = new Vue({
	store,
  ...App
})

// http拦截器
import HTTPInterceptor from '@/common/http.interceptor.js'
Vue.use(HTTPInterceptor, app)

// http接口API集中管理引入部分
import HTTPApi from '@/common/http.api.js'
Vue.use(HTTPApi, app)

// 自定义方法
import common from './utils/common.js'
Vue.use(common, app)

app.$mount()
