export default {
  data() {
    return {
      elementData: {
        dataList: {}
      },
      timer: null
    }
  },
  props: {
    elementInfo: {
			type: Object,
			required: true
		}
  },
  methods: {
		/**
		 * 静态数据
		 */
		handleStaticData(value) {
			this.elementData.dataList = JSON.parse(JSON.stringify({...value.dataList}))
			this.initChart()
		},
		/**
		 * 动态数据
		 */
		async handleDynamicData (value) {
			const that = this
			let { dataUrl, dataMethod, dataFormatter, dataProcessing } = { ...value }
			dataUrl = dataUrl.replace(/^(\/dashboardCharts)?|^(\/dashboardAPI)?/, '')
			let res = await that.$u.api[`${dataMethod.toLowerCase()}Http`](dataUrl, dataFormatter, {
				custom: { loading: false }
			})
			if (dataProcessing) {
				that.elementData.dataList = that.$u.common.converFunction(dataProcessing, res.data)
			} else {
				that.elementData.dataList = JSON.parse(JSON.stringify(res.data.Result))
			}
			this.initChart()
		},
		/**
		 * 全局数据
		 */
		handlePublicData (value) {
			if (!this.vuex_globalData) return
			const { dataProcessing } = { ...value }
			if (dataProcessing) {
				this.elementData.dataList = this.$u.common.converFunction(dataProcessing, this.vuex_globalData)
			} else {
				this.elementData.dataList = this.vuex_globalData
			}
			this.initChart()
		},
		/**
		 * 配置数据 - 数据集
		 */
		async handleDataSet (value) {
			const { dataSetInfo } = value
			const that = this
			let res = await that.$u.api.dataSetPreview(dataSetInfo)
			const { Status, Msg } = res.data;
			if (Status == "true") {
				if(dataSetInfo.script) {
					that.elementData.dataList = that.$u.common.converFunction(dataSetInfo.script, res.data.Result)
				} else {
					that.elementData.dataList = res.data.Result
				}
				this.initChart()
			} else {
				that.$u.toast(Msg)
			}
		},
		clearTimer() {
			clearInterval(this.timer)
			this.timer = null
		},
		/**
		 * 组件点击交互 - 传参
		 */
		handleEchartsClick (chartEvent ) {
			const { index, paramName } = this.elementInfo.child
			uni.$emit('handleLinkParams', { index, paramName, value: chartEvent.name })
		}
  },
  deactivated() {
    this.clearTimer()
  },
  beforeDestroy() {
    this.clearTimer()
  },
  watch: {
		'elementInfo.data': {
			handler(newVal) {
				const that = this
				if(that.elementInfo.hide) return false
				if (newVal.dataType === 'static') {
					that.handleStaticData(newVal)
				}
				else if (newVal.dataType === 'dynamic') {
					that.handleDynamicData(newVal)
					if (newVal.dataPolling) {
						that.timer = setInterval(() => {
							that.handleDynamicData(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				}
				else if (newVal.dataType === 'public') {
					that.handlePublicData(newVal)
				}
				else if (newVal.dataType === 'dataSet') {
					that.handleDataSet(newVal)
					if (newVal.dataPolling) {
						that.timer = setInterval(() => {
							that.handleDataSet(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				}
			},
			deep: true,
			immediate: true
		},
		/**
		 * 全局数据更新监测
		 */
		'vuex_globalData' () {
			if (this.elementInfo.data.dataType === 'public') this.handlePublicData(this.elementInfo.data)
		}
  }
}
