// 请求的本域名
const baseUrl = 'https://api.charleskeith.cn/api'   // 正式环境
// const reportUrl = 'http://192.168.138.55:8081/api'  // 测试环境
// const reportUrl = 'http://47.101.191.49:8083/api'  // 外网测试环境
const reportUrl = 'https://api.charleskeith.cn/api'   // 正式环境
const install = (Vue, vm) => {
	let getHttp = (url, params, config) => vm.$http.get(url, { params }, config)
	let postHttp = (url, params, config) => vm.$http.post(url, params, config)
	/*************** 认证 API *****************/
	// 登录
	let quickLogin = params => postHttp(`${baseUrl}/report/user/quickLogin`, params)
	// 注册
	let register = params => postHttp(`${baseUrl}/report/user/register`, params)
	// 报表列表
	const getReportList = params => getHttp(`${reportUrl}/report/screen/getList`, params)
	// 报表组件列表
	const getReportCharts = params => getHttp(`${reportUrl}/report/chart/getReleaseList`, params)
	// 数据集
	const dataSetPreview = params => postHttp(`${reportUrl}/report/dataset/preview`, params, {
		custom: {
			loading: false
		}
	})
	// 视图
	const buildChart = params => postHttp(`${reportUrl}/report/dataview/buildChart`, params, {
		custom: {
			loading: false
		}
	})
	// 检查授权状态
	const getAuthorized = params => getHttp(`${baseUrl}/report/user/getAuthorized`, params)
	// 获取用户数据
	const getUserListCount = params => getHttp(`${baseUrl}/report/user/getUserListCount`, params)
	// 修改密码
	const changePassword = params => postHttp(`${baseUrl}/report/user/changePassword`, params)
	// 获取用户数据
	const getAuthorizedList = params => getHttp(`${baseUrl}/report/user/getAuthorizedList`, params)
	// 授权/取消授权
	const authorizeOrUnauthorize = params => postHttp(`${baseUrl}/report/user/authorizeOrUnauthorize`, params)
	// 获取OPENID
	const getOpenId = params => getHttp(`${baseUrl}/report/user/getOpenId`, params)
	
	vm.$u.api = {
		getHttp,
		postHttp,
		quickLogin,
		register,
		getReportList,
		getReportCharts,
		dataSetPreview,
		buildChart,
		getAuthorized,
		getUserListCount,
		changePassword,
		getAuthorizedList,
		authorizeOrUnauthorize,
		getOpenId
	}
}

export default {
	install
}