import { Function } from '../static/plugin/eval5/eval5.js'

const install = (Vue, vm) => {
	/**
	 * 数据转换
	 */
	const converFunction = (func, data) => {
	  if(!func) return
	  return new Function('"use strict";return (' + func + ')')()(data);
	}
	
	/**
	   * 补足数字位数
	   * @param digit 数字
	   * @param len 位数
	   */
	const fillDigit = (digit, len) => {
	  return padStart('' + digit, len, '0')
	}
	
	const toThousands = (value) => {
	  let result = ''
	  let num = (parseInt(value) || 0).toString()
	  while (num.length > 3) {
	    result = ',' + num.slice(-3) + result
	    num = num.slice(0, num.length - 3)
	  }
	  if (num) {
	    result = num + result
	  }
	  return result
	}
	
	vm.$u.common = {
		converFunction,
		fillDigit,
		toThousands
	}
}

export default {
	install
}