const install = (Vue, vm) => {
	Vue.prototype.$u.http.setConfig({
		baseUrl: 'https://api.charleskeith.cn', // 请求的本域名
		// baseUrl: 'http://192.168.138.55:808l',
		showLoading: true, // 是否显示请求中的loading
		loadingText: '努力加载中。。。', // 请求loading中的文字提示
		loadingTime: 300, // 在此时间内，请求还没回来的话，就显示加载中动画，单位ms
		loadingMask: true, // 展示loading的时候，是否给一个透明的蒙层，防止触摸穿透
		originalData: true, // 是否在拦截器中返回服务端的原始数据
		// 配置请求头信息
		header: {
			"Content-Type": "application/json"
		},
	})
	
	/**
	 * 请求拦截
	 */
	Vue.prototype.$u.http.interceptor.request = (config) => {
		config.header.Authorization = vm.vuex_token
		return config
	}
	
	/**
	 * 响应拦截
	 */
	Vue.prototype.$u.http.interceptor.response = (res) => {
		const { statusCode, data } = res
		if(statusCode < 400) {
			return res
		} else if(statusCode == 400) {
			vm.$u.toast(data.message)
			return false
		} else if(statusCode == 401) {
			if(data.massage === 'Unauthorized') {
				vm.$u.toast("账号或密码错误")
			} else if(data.message === "Token has expired") {
				vm.$u.toast("Token 已过期, 请重新登录")
			}
			return false
		} else if(statusCode == 422) {
			const {errors} = data
			vm.$u.toast(Object.values(errors)[0][0])
			return false
		} else {
			vm.$u.toast("请求失败，到控制台查看原因")
			return false
		}
	}
	
	// 添加 patch 请求
	vm.$u.patch = (url, params = {}) => {
		// 模拟 patch 请求
		const _params = {
			...params,
			_method: 'PATCH'
		}
		return vm.$u.post(url, _params)
	}
}

export default {
	install
}