export default {
  data() {
    return {
      elementData: {},
      timer: null
    }
  },
  props: {
    elementInfo: {
			type: Object,
			required: true
		}
  },
	computed: {
		elStyleObject() {
			const { windowWidth } = uni.getSystemInfoSync()
			const { width, height } = this.elementInfo
			return {
				'width': `${width > windowWidth ? '100%' : width + 'px'}`,
				'height': `${width > windowWidth ? height / width * windowWidth : height}px`
			}
		}
	},
  methods: {
		/**
		 * 静态数据
		 */
		handleStaticData(value) {
			this.elementData = JSON.parse(JSON.stringify({...value}))
			this.initChart()
		},
		/**
		 * 动态数据
		 */
		async handleDynamicData (value) {
			let { dataUrl, dataMethod, dataFormatter, dataProcessing } = { ...value }
			dataUrl = dataUrl.replace(/^(\/dashboardCharts)?|^(\/dashboardAPI)?/, '')
			const params = dataMethod === 'GET' ? { params: dataFormatter } : dataFormatter
			let res = await this.$u.api[`${dataMethod.toLowerCase()}Http`](dataUrl, params, {
				custom: { loading: false }
			})
			if (dataProcessing) {
				this.elementData.dataList = this.$u.common.converFunction(dataProcessing, res.data)
			} else {
				this.elementData.dataList = JSON.parse(JSON.stringify(res.data.Result))
			}
			this.initChart()
		},
		/**
		 * 全局数据
		 */
		handlePublicData (value) {
			if (!this.vuex_globalData) return
			const { dataProcessing } = { ...value }
			if (dataProcessing) {
				this.elementData.dataList = this.$u.common.converFunction(dataProcessing, JSON.parse(this.vuex_globalData))
			} else {
				this.elementData.dataList = JSON.parse(this.vuex_globalData)
			}
			this.initChart()
		},
		/**
		 * 配置数据 - 数据集
		 */
		async handleDataSet (value) {
			const { dataSetInfo } = value
			let res = await this.$u.api.dataSetPreview(dataSetInfo)
			const { Status, Msg } = res.data;
			if (Status == "true") {
				if(dataSetInfo.script) {
					this.elementData.dataList = this.$u.common.converFunction(dataSetInfo.script, res.data.Result)
				} else {
					this.elementData.dataList = res.data.Result
				}
				this.initChart()
			} else {
				this.$u.toast(Msg)
			}
		},
		clearTimer() {
			clearInterval(this.timer)
			this.timer = null
		},
		/**
		 * 组件点击交互 - 传参
		 */
		handleEchartsClick (chartEvent ) {
			const { index, paramName } = this.elementInfo.child
			uni.$emit('handleLinkParams', { index, paramName, value: chartEvent.name })
		}
  },
  deactivated() {
    this.clearTimer()
  },
  beforeDestroy() {
    this.clearTimer()
  },
  watch: {
		'elementInfo.data': {
			handler(newVal) {
				if (newVal.dataType === 'static') {
					this.handleStaticData(newVal)
				}
				else if (newVal.dataType === 'dynamic') {
					this.handleDynamicData(newVal)
					if (newVal.dataPolling) {
						this.timer = setInterval(() => {
							this.handleDynamicData(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(this.timer)
					}
				}
				else if (newVal.dataType === 'public') {
					this.handlePublicData(newVal)
				}
				else if (newVal.dataType === 'dataSet') {
					this.handleDataSet(newVal)
					if (newVal.dataPolling) {
						this.timer = setInterval(() => {
							this.handleDataSet(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(this.timer)
					}
				}
			},
			deep: true,
			immediate: true
		},
		/**
		 * 全局数据更新监测
		 */
		'vuex_globalData' () {
			if (this.elementInfo.data.dataType === 'public') this.handlePublicData(this.elementInfo.data)
		}
  }
}
