import { Function } from '../static/plugin/eval5/eval5.js'

const install = (Vue, vm) => {
	/**
	 * 数据转换
	 */
	const converFunction = (func, data) => {
	  if(!func) return
	  return new Function('"use strict";return (' + func + ')')()(data);
	}
	
	/**
	   * 补足数字位数
	   * @param digit 数字
	   * @param len 位数
	   */
	const fillDigit = (digit, len) => {
	  return padStart('' + digit, len, '0')
	}
	
	const toThousands = (value) => {
	  let result = ''
	  let num = (parseInt(value) || 0).toString()
	  while (num.length > 3) {
	    result = ',' + num.slice(-3) + result
	    num = num.slice(0, num.length - 3)
	  }
	  if (num) {
	    result = num + result
	  }
	  return result
	}
    
	const dateFormat = () => {
	    let date = new Date();
	    let year = date.getFullYear();
	    // 在日期格式中，月份是从0开始的，因此要加0，使用三元表达式在小于10的前面加0，以达到格式统一  如 09:11:05
	    let month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
	    let day = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
	    let hours = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
	    let minutes = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
	    let seconds = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
	    // 拼接
	    return year + "-" + month + "-" + day + " " + hours + ":" + minutes + ":" + seconds;
	    // return year + "-" + month + "-" + day;
	}
	
	// px转换为rpx
	const pxToRpx = (value) => {
		return value / uni.getSystemInfoSync().windowWidth * 750
	}

	// rpx转换为px
	const rpxToPx = (value) => {
		return value / 750 * uni.getSystemInfoSync().windowWidth	
	}
	
	vm.$u.common = {
		converFunction,
		fillDigit,
		toThousands,
		dateFormat,
		pxToRpx,
		rpxToPx
	}
}

export default {
	install
}