export default {
  data() {
    return {
      elementData: {
        dataList: {}
      },
      timer: null
    }
  },
  props: {
    elementInfo: {
			type: Object,
			required: true
		}
  },
  methods: {
		setStorageData() {
			uni.setStorageSync(this.elementInfo.id, JSON.stringify(this.elementData.dataList))
		},
		/**
		 * 静态数据
		 */
		handleStaticData(value) {
			this.elementData.dataList = JSON.parse(JSON.stringify({...value.dataList}))
		},
		/**
		 * 动态数据
		 */
		async handleDynamicData (value) {
			const that = this
			let { dataUrl, dataMethod, dataFormatter, dataProcessing } = { ...value }
			if(value.queryFormatter) dataFormatter = {...dataFormatter, ...value.queryFormatter}
			dataUrl = dataUrl.replace(/^(\/(dashboardCharts|dashboardAPI))?/, '')
			dataFormatter = that.$u.common.filterRequestParams({...dataFormatter})
			let res = await that.$u.api[`${dataMethod.toLowerCase()}Http`](dataUrl, dataFormatter, {
				custom: { loading: false }
			})
			if (dataProcessing) {
				that.elementData.dataList = that.$u.common.converFunction(dataProcessing, res.data)
			} else {
				that.elementData.dataList = JSON.parse(JSON.stringify(res.data.Result))
			}
		},
		/**
		 * 全局数据
		 */
		handlePublicData (value) {
			if (!this.vuex_globalData) return
			const { dataProcessing } = { ...value }
			if (dataProcessing) {
				this.elementData.dataList = this.$u.common.converFunction(dataProcessing, this.vuex_globalData, value.queryFormatter)
			} else {
				this.elementData.dataList = this.vuex_globalData
			}
		},
		/**
		 * 配置数据 - 数据集
		 */
		async handleDataSet (value) {
			const { dataSetInfo } = value
			const that = this
			let res = await that.$u.api.dataSetPreview(dataSetInfo)
			const { Status, Msg } = res.data;
			if (Status == "true") {
				if(dataSetInfo.script) {
					that.elementData.dataList = that.$u.common.converFunction(dataSetInfo.script, res.data.Result)
				} else {
					that.elementData.dataList = res.data.Result
				}
			} else {
				that.$u.toast(Msg)
			}
		},
		
		/**
			* 视图配置
		*/
		async handleViewConfig (value) {
			const { viewConfig } = value
			if (!viewConfig.dataSetId) return
			const that = this
			const res = await that.$u.api.buildChart(viewConfig)
			const { Status, Msg, Result } = res.data
			if (Status === 'true') {
				that.elementData.dataList = Result
			}else {
				message.warning(Msg)
			}
		},
		/** 文件数据 */
		handleFolderData(data) {
			const { dataProcessing } = { ...data }
			uni.$on(`folder_${this.elementInfo.folderId}`, (value) => {
				if(!value) return
				if (dataProcessing) {
					this.elementData.dataList = this.$u.common.converFunction(dataProcessing, value)
				} else {
					this.elementData.dataList = JSON.parse(JSON.stringify(value))
				}
			})
		},

		clearTimer() {
			clearInterval(this.timer)
			this.timer = null
		},
		/**
		 * 组件点击交互 - 传参
		 */
		handleEchartsClick (chartEvent ) {
			const { index, paramName } = this.elementInfo.child
			uni.$emit('handleLinkParams', { index, paramName, value: chartEvent.name })
		},
		/**
		 * 组件datazoom交互 
		 */
		echartsDataZoom (chartEvent ) {
			const { index, paramName } = this.elementInfo.child
			uni.$emit('handleDataZoomParams', { index, paramName, value: chartEvent })
		}
  },
  deactivated() {
    this.clearTimer()
  },
  beforeDestroy() {
    this.clearTimer()
  },
  watch: {
		'elementInfo.data': {
			handler(newVal) {
				const that = this
				const storageData = uni.getStorageSync(this.elementInfo.id)
				if(storageData && newVal.dataType !== 'static') {
					this.elementData.dataList = JSON.parse(storageData)
				}
				if(that.elementInfo.hide) return false
				if (newVal.dataType === 'static') {
					that.handleStaticData(newVal)
				} else if (newVal.dataType === 'dynamic') {
					that.handleDynamicData(newVal)
					if (newVal.dataPolling) {
						that.timer = setInterval(() => {
							that.handleDynamicData(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				} else if (newVal.dataType === 'public') {
					that.handlePublicData(newVal)
				} else if (newVal.dataType === 'dataSet') {
					that.handleDataSet(newVal)
					if (newVal.dataPolling) {
						that.timer = setInterval(() => {
							that.handleDataSet(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				} else if (newVal.dataType === 'viewConfig') {
					that.handleViewConfig(newVal)
					if (newVal.dataPolling) {
						that.timer = setInterval(() => {
							that.handleViewConfig(newVal)
						}, newVal.dataPollingInterval * 1000)
					} else {
						clearInterval(that.timer)
					}
				} else if (newVal.dataType === 'folder') {
				  that.handleFolderData(newVal)
				}
			},
			deep: true,
			immediate: true
		},
		/**
		 * 全局数据更新监测
		 */
		'vuex_globalData' () {
			if (this.elementInfo.data.dataType === 'public') this.handlePublicData(this.elementInfo.data)
		},
		'elementData.dataList': {
			handler(newVal) {
				this.setStorageData()
				this.initChart()
			},
			deep: true,
			immediate: true
		}
  }
}
