import {
	Function
} from '../static/plugin/common/index.js'

const install = (Vue, vm) => {
	/**
	 * 数据转换
	 */
	const converFunction = (func, data, filter = {}) => {
		if (!func) return
		return new Function('"use strict";return (' + func + ')')()(data, filter);
	}

	/**
	 * 补足数字位数
	 * @param digit 数字
	 * @param len 位数
	 */
	const fillDigit = (digit, len) => {
		return padStart('' + digit, len, '0')
	}

	const toThousands = (value) => {
		let result = ''
		let num = (parseInt(value) || 0).toString()
		while (num.length > 3) {
			result = ',' + num.slice(-3) + result
			num = num.slice(0, num.length - 3)
		}
		if (num) {
			result = num + result
		}
		return result
	}

	const dateFormat = () => {
		let date = new Date();
		let year = date.getFullYear();
		// 在日期格式中，月份是从0开始的，因此要加0，使用三元表达式在小于10的前面加0，以达到格式统一  如 09:11:05
		let month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
		let day = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
		let hours = date.getHours() < 10 ? "0" + date.getHours() : date.getHours();
		let minutes = date.getMinutes() < 10 ? "0" + date.getMinutes() : date.getMinutes();
		let seconds = date.getSeconds() < 10 ? "0" + date.getSeconds() : date.getSeconds();
		// 拼接
		return year + "-" + month + "-" + day + " " + hours + ":" + minutes + ":" + seconds;
	}

	// px转换为rpx
	const pxToRpx = (value) => {
		return value / uni.getSystemInfoSync().windowWidth * 750
	}

	// rpx转换为px
	const rpxToPx = (value) => {
		return value / 750 * uni.getSystemInfoSync().windowWidth
	}

	const slice = (array, start, end) => {
		let length = array == null ? 0 : array.length
		if (!length) {
			return []
		}
		start = start == null ? 0 : start
		end = end === undefined ? length : end

		if (start < 0) {
			start = -start > length ? 0 : (length + start)
		}
		end = end > length ? length : end
		if (end < 0) {
			end += length
		}
		length = start > end ? 0 : ((end - start) >>> 0)
		start >>>= 0

		let index = -1
		const result = new Array(length)
		while (++index < length) {
			result[index] = array[index + start]
		}
		return result
	}

	/**
	 * 将数组（array）拆分成多个 size 长度的区块，并将这些区块组成一个新数组。
	 * 如果array无法被分割成全部等长的区块，那么最后剩余的元素将组成一个区块。
	 */
	const chunk = (array, size = 1) => {
		const length = array == null ? 0 : array.length
		if (!length || size < 1) {
			return []
		}
		let index = 0
		let resIndex = 0
		const result = new Array(Math.ceil(length / size))

		while (index < length) {
			result[resIndex++] = slice(array, index, (index += size))
		}
		return result
	}
	/**
	 * 从string中提取参数
	 */
	const getQueryFromString = (string) => {
		const num = string.indexOf("?")
		const qs = string.substr(num + 1) // 获取url中"?"符后的字串  
		let args = {} // 保存参数数据的对象
		const items = qs.length ? qs.split("&") : [] // 取得每一个参数项,
		let item = null
		const len = items.length;

		for (var i = 0; i < len; i++) {
			item = items[i].split("=");
			var name = decodeURIComponent(item[0]),
				value = decodeURIComponent(item[1]);
			if (name) {
				args[name] = value;
			}
		}
		return args;
	}

	const filterRequestParams = (params) => {
		let paramStr = JSON.stringify(params)
		if (paramStr.includes('@year')) {
			paramStr = paramStr.replace(/@year/g, yearly())
		}
		if (paramStr.includes('@month')) {
			paramStr = paramStr.replace(/@month/g, monthly())
		}
		if (paramStr.includes('@day')) {
			paramStr = paramStr.replace(/@day/g, day())
		}
		if (paramStr.includes('@daily')) {
			const d = daily()
			paramStr = paramStr.replace(/@daily/g, daily())
		}
		if (paramStr.includes('@yesterday')) {
			paramStr = paramStr.replace(/@yesterday/g, yesterday())
		}

		return JSON.parse(paramStr)
	}

	const yearly = () => {
		const date = new Date();
		const year = date.getFullYear();
		return year
	}

	const monthly = () => {
		const date = new Date();
		const month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
		return month
	}

	const day = () => {
		const date = new Date();
		const day = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
		return day
	}

	const daily = () => {
		const date = new Date();
		const year = date.getFullYear();
		// 在日期格式中，月份是从0开始的，因此要加0，使用三元表达式在小于10的前面加0，以达到格式统一  如 09:11:05
		const month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
		const day = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
		// 拼接
		return year + "-" + month + "-" + day;
	}

	const yesterday = () => {
		const date = new Date()
		const timestamp = date.getTime() - 1000 * 24 * 60 * 60
		date.setTime(timestamp)
		const year = date.getFullYear();
		// 在日期格式中，月份是从0开始的，因此要加0，使用三元表达式在小于10的前面加0，以达到格式统一  如 09:11:05
		const month = date.getMonth() + 1 < 10 ? "0" + (date.getMonth() + 1) : date.getMonth() + 1;
		const day = date.getDate() < 10 ? "0" + date.getDate() : date.getDate();
		// 拼接
		return year + "-" + month + "-" + day;
	}

	vm.$u.common = {
		converFunction,
		fillDigit,
		toThousands,
		dateFormat,
		pxToRpx,
		rpxToPx,
		chunk,
		getQueryFromString,
		filterRequestParams
	}
}

export default {
	install
}
